 ; Ŀ
 ;   Dimp - change extension line endpoints.                               
 ;   Copyright 1994 by Rocket Software                                     
 ;   Dimp - technical term for an ice cream cone with the base bitten off. 
 ; 
 (DEFUN C:DIMP (/ entt ten thrt fort angac pa ptx pty leftpt rtpt)
  (setq entt (entsel "Select a Dimension: "))
  (cond ((null entt) (prompt "\nNothing selected."))
        ((/= (cdr (assoc 0 (setq entt (entget (car entt))))) "DIMENSION")
         (prompt "\nThat wasn't a dimension."))
        (T
         (setq ten (cdr (assoc 10 entt)))        ; right dim. line end
         (setq thrt (cdr (assoc 13 entt)))       ; left ext. line end
         (setq fort (cdr (assoc 14 entt)))       ; right ext. line end
         (setq angac (cdr (assoc 50 entt)))      ; overall dimension angle
 ; Ŀ
 ;   Now want to find Pa: the left end of the dimension line.              
 ;   Draw a line from Ten at angle Angac, Pa is the intersection of this   
 ;   with a line drawn from Thrt at right angles to Angac.                 
 ; 
         (setq pa (inters ten (polar ten angac 10)
                      thrt (setq pta1 (polar thrt (+ angac (/ pi 2)) 10)) ()))
 ; Ŀ
 ;   Get a point indicating on which side to change the extension line     
 ;   and how far to extend it.                                             
 ; 
         (setq ptx (getpoint "\nNew extension endpoint: "))
 ; Ŀ
 ;   Make the other end of an imaginary line at right angles to the        
 ;   extension line angle...                                               
 ; 
         (setq pty (polar ptx angac 10))
 ; Ŀ
 ;   ...and use it to find where ptx would be if it were on the left       
 ;   extension line...                                                     
 ; 
         (setq leftpt (inters pa pta1 ptx pty ()))
 ; Ŀ
 ;   ...and where it would be on the right.                                
 ; 
         (setq rtpt (inters ten (polar ten (+ angac (/ pi 2)) 10) ptx pty ()))
 ; Ŀ
 ;   Now change the side to which ptx was closer.                          
 ; 
         (if (< (distance leftpt ptx) (distance rtpt ptx))
             (entmod (subst (cons 13 leftpt) (assoc 13 entt) entt))  ; left
             (entmod (subst (cons 14 rtpt) (assoc 14 entt) entt))))) ; right
 (princ))